libname q 'c:/SASCodeforBook/SASDataSets';
data tryone; set q.humandevelexportable;

        /*This syntax makes the standard HDIRank Runs Replicating the Chapter's Tables*/

        /*These runs weight the country by the square root of its population*/

        /* Code for Table 7.2, Descriptive Models of Human Development Rank*/
        /* s is an appreviation for solution*/
        /* These runs do not use the parms/nobound statement. If implemented it requests a likelihood
        ratio test for the variance components and changes the bounds on their confidence limits*/
        /* Figures 7.2 and 7.3 depict some of these estimates*/

Title '7.2 Model 1, Mixed Weighted no nesting,  HDIRank, Intercepts Only';
proc mixed covtest ratio  cl=wald ;
        class  region culture slave98 fretyp99 Debt conflict coruptyp;
        model hdirank =  /solution ;
        random region/solution;
        weight sqrtpop;
        *parms/nobound;
        *Figure 7.2 depicts random effects estimates;
run;

Title '7.2 Model 2, Mixed weighted no nesting,  HDIRank, Full Descriptive Model';
proc mixed covtest ratio cl=wald;
        class  region culture slave98 fretyp99 Debt conflict coruptyp;
        model hdirank = culture slave98 fretyp99 debt conflict corrupt /s ;
        random region/solution;
        lsmeans culture / pdiff adjustment = bon cl;
        weight sqrtpop;
        *parms/nobound;
        *Figure 7.2 depicts random effects estimates;
        *Figure 7.3 depicts the least-square means for culture;
run;

Title '7.2 Model 3, Mixed weighted no nesting,  HDIRank, no Civilizations (no culture)';
proc mixed covtest ratio  cl=wald ;
        class  region slave98 fretyp99 debt conflict coruptyp;
        model hdirank =  slave98 fretyp99 debt conflict corrupt /s ;
        random region/solution;
        weight sqrtpop;
        *parms/nobound;
        * Figure 7.2 depicts random effects estimates;
run;

Title ' 7.2 Model 4, Mixed weighted no nesting,  HDIRank, no Slavery (no slave98)';
proc mixed covtest ratio  cl=wald ;
        class  region culture fretyp99 debt conflict coruptyp;
        model hdirank = culture fretyp99 debt conflict corrupt /s ;
        random region/solution;
        weight sqrtpop;
        *parms/nobound;
run;

Title ' 7.2 Model 5, Mixed weighted no nesting,  HDIRank, no Freedom (no fretyp99)';
proc mixed covtest ratio  cl=wald ;
        class  region culture slave98 debt conflict coruptyp;
        model hdirank = culture slave98 debt conflict corrupt /s ;
        random region/solution;
        weight sqrtpop;
        *parms/nobound;
run;

Title ' 7.2 Model 6, Mixed weighted no nesting, HDIRank, No HIPC, no Heavy Dept (no debt)';
proc mixed covtest ratio  cl=wald ;
        class  region culture slave98 fretyp99 conflict coruptyp;
        model hdirank = culture slave98 fretyp99 conflict corrupt /s ;
        random region/solution;
        weight sqrtpop;
        *parms/nobound;
run;

Title '7.2 Model 7, Mixed weighted no nesting, HDIRank, no Conflict (no conflict)';
proc mixed covtest ratio  cl=wald ;
        class  region culture slave98 fretyp99 debt coruptyp;
        model hdirank = culture slave98 fretyp99 debt corrupt /s ;
        random region/solution;
        weight sqrtpop;
        *parms/nobound;
run;

Title '7.2 Model 8, Mixed weighted no nesting,  HDIRank, no corruption (no coruptyp)';
proc mixed covtest ratio  cl=wald ;
        class  region culture slave98 fretyp99 debt conflict;
        model hdirank = culture slave98 fretyp99 debt conflict/s ;
        random region/solution;
        weight sqrtpop;
        *parms/nobound;
run;

        /*Footnotes to Table 7.2, dichotomized freedom and slavery, respectively*/

Title '7.2 Model 2a, first table footnote a Mixed weighted no nesting, HDIRank, Full Model,
        freedom dichotomized=dichofre)';
proc mixed covtest ratio  cl=wald ;
        class  region culture slave98 dichofre debt conflict coruptyp;
        model hdirank = culture slave98 dichofre debt conflict corrupt /s ;
        random region/solution;
        weight sqrtpop;
        *parms/nobound;
run;

Title '7.2 Model 6a, second table footnote a, Mixed weighted no nesting, HDIRank, Full Model,
        freedom dichotomized=dichofre), no debt';
proc mixed covtest ratio  cl=wald ;
        class  region culture slave98 dichofre conflict coruptyp;
        model hdirank = culture slave98 dichofre conflict corrupt /s ;
        random region/solution;
        weight sqrtpop;
        *parms/nobound;
run;

Title ' 7.2 Model 7a, table footnote b, Mixed weighted no nesting, HDIRank, Full Model,
        slavery dichotomized = emancip, no conflict';
proc mixed covtest ratio  cl=wald ;
        class  region culture emancip fretyp99 debt coruptyp;
        model hdirank = culture emancip fretyp99 debt corrupt /s ;
        random region/solution;
        weight sqrtpop;
        *parms/nobound;
run;

        /* The code for Table 7.2 is now complete*/
		/* The syntax in this file is copyright by Robert B. Smith  2011 */
